/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandNode
extends BaseNode<Property> {
    private static final Image COMMAND_ICON = ScriptingUIPlugin.getImage("icons/command.png");
    private CommandElement command;

    CommandNode(CommandElement command) {
        this.command = command;
    }

    @Override
    public Image getImage() {
        return COMMAND_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.command.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<CommandNode>
    {
        NAME(Messages.CommandNode_Command_Name){

            public Object getPropertyValue(CommandNode node) {
                return node.command.getDisplayName();
            }
        }
        ,
        PATH(Messages.CommandNode_Command_Path){

            public Object getPropertyValue(CommandNode node) {
                return node.command.getPath();
            }
        }
        ,
        SCOPE(Messages.CommandNode_Command_Scope){

            public Object getPropertyValue(CommandNode node) {
                String scope = node.command.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.CommandNode_All_Scopes;
            }
        }
        ,
        EXECUTABLE(Messages.CommandNode_Command_Executable){

            public Object getPropertyValue(CommandNode node) {
                return node.command.isExecutable();
            }
        }
        ,
        TYPE(Messages.CommandNode_Command_Type){

            public Object getPropertyValue(CommandNode node) {
                String result = node.command.isBlockCommand() ? Messages.CommandNode_Command_Ruby_Block : (node.command.isShellCommand() ? Messages.CommandNode_Command_Shell_Script : Messages.CommandNode_Unknown_Execution_Type);
                return result;
            }
        }
        ,
        INPUTS(Messages.CommandNode_Command_Inputs){

            public Object getPropertyValue(CommandNode node) {
                InputType[] inputs = node.command.getInputTypes();
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (i < inputs.length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(inputs[i].getName());
                    ++i;
                }
                return buffer.toString();
            }
        }
        ,
        OUTPUT(Messages.CommandNode_Command_Output){

            public Object getPropertyValue(CommandNode node) {
                return node.command.getOutputType();
            }
        }
        ,
        TRIGGERS(Messages.CommandNode_Command_Triggers){

            public Object getPropertyValue(CommandNode node) {
                String[] triggers = node.command.getTriggerTypeValues(TriggerType.PREFIX);
                if (triggers != null && triggers.length > 0) {
                    StringBuilder buffer = new StringBuilder();
                    int i = 0;
                    while (i < triggers.length) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(triggers[i]);
                        ++i;
                    }
                    return buffer.toString();
                }
                return null;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

